//
//  OPDataProcessorDecryptor.h
//  Image Downloader
//
//  Created by Nathan Van Fleet on 2015-05-29.
//  Copyright (c) 2015 Nathan Van Fleet. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "OPDataAccessorBase.h"

@class OPSymmetricKey;

// Decrypts files to memory and returns NSData
@interface OPSymmetricKeyDecryptor : OPDataProcessorBase
@property (strong, nonatomic) OPSymmetricKey *key;
@property (strong, nonatomic) NSData *nonce;
@end

// Decrypts large files to temp and returns a NSURL file reference
// Note: This decrypts the file to the temp directory of the app and you may want to clear it
@interface OPLargeFileSymmetricKeyDecryptor : OPSymmetricKeyDecryptor
@property (strong, nonatomic) NSURL *destinationFileURL;
@end
